/*
 ============================================================================
 Name        : Project_KernelMod.c
 Author      : Tyler Mironuck
 Version     :
 Copyright   : Your copyright notice
 Description : Hello World in C, Ansi-style
 ============================================================================
 */

#ifndef MODULE
#define MODULE
#endif

#ifndef __KERNEL__
#define __KERNEL__
#endif


#include <linux/module.h>
#include <linux/kernel.h>
#include <asm/io.h>
#include <rtai.h>
#include <rtai_sched.h>	//scheduler
#include <rtai_fifos.h>		//for Fifos
#include <linux/time.h>
#include <linux/time.h>


MODULE_LICENSE("GPL");

unsigned long *startPtr, *startPtr2, *PBDR, *PBDDR, *GPIOBIntEn, *RawIntStsB;
unsigned long *GPIOBEOI, *GPIOBIntType1, *GPIOBIntType2, *GPIOBDB;
int portB_Status;
//VIC2 handles Interrupt lines 32 through 63
unsigned long *VIC2SoftIntClear, *VIC2IntEnable;

//declare variables of struct timeval
struct timeval Time;
struct timeval TimeOfPress;
struct timeval YellowLightBegin;
struct timeval YellowLightEnd;


static RT_TASK mytask;
RTIME period;

static void my_handler(unsigned irq_num, void *cookie){
	rt_disable_irq(59);			//Disable request line so no new interrupts can trigger
	portB_Status = *RawIntStsB;		//Assign status of portB interrupt to portB_Status

	if((portB_Status & 0x01) != 0x00){								//If bit 0 button of port B is pressed
		do_gettimeofday(&TimeOfPress);								//collect timestamp of when button was pressed
		rtf_put(0, &TimeOfPress, sizeof(TimeOfPress));				//Send timeStamp of button press to program
	}
	rtf_put(1, &YellowLightBegin, sizeof(YellowLightBegin));	//Send timeStamp of yellow light begin
	//rt_sleep(nano2count(100000));
	*GPIOBEOI |= 0x0000001F;	//clear interrupt (EOI stands for End Of Interrupt)
	rt_enable_irq(59);			//Re-enable interrupt handling
}

static void my_software_handler(unsigned irq_num, void *cookie){
	int level = 0;

	rt_disable_irq(63);					//Disable interrupt handling so no new interrupts can trigger

	rtf_get(3, &level, sizeof(level));	//Retrieve note from UserSpace program via FIFO

		if(level == 1){
			rt_task_make_periodic(&mytask, rt_get_time()+10*period, 4000 *period);		//Makes lowest frequency
		}
		else if(level == 2){
				rt_task_make_periodic(&mytask, rt_get_time()+10*period, 2000 *period);		//Increase frequency
			}
		else if(level == 3){
			rt_task_make_periodic(&mytask, rt_get_time()+10*period, 1300 *period);		//Increase frequency
		}
		else if(level == 4){
			rt_task_make_periodic(&mytask, rt_get_time()+10*period, 1100 *period);		//Increase frequency
		}
		else if(level == 5){
			rt_task_make_periodic(&mytask, rt_get_time()+10*period, 900 *period);		//Increase Frequency
		}
		else if(level == 5){
			rt_task_make_periodic(&mytask, rt_get_time()+10*period, 700 *period);		//Makes highest frequency
		}

	*VIC2SoftIntClear |= 0x80000000;	//Clear software interrupt 63 (Clears bit 31 but it is in VIC2 so it actually clears line 63)
	rt_enable_irq(63);					//Re-enable interrupt handling

}
static void rt_process(int t)	//argument not used
{
	while(1){
		*PBDR |= 0x80;							//Turn on green light
		rt_task_wait_period();					//wait for a period
		*PBDR &= 0xFFFFFF7F;					//Turn off green light
		do_gettimeofday(&YellowLightBegin);		//Collect time stamp of when yellow light begins
		//rtf_put(1, &YellowLightBegin, sizeof(YellowLightBegin));	//Send timeStamp of yellow light begin
		*PBDR |= 0x40;							//Turn on yellow light
		rt_task_wait_period();					//wait for a period
		*PBDR &= 0xFFFFFFBF;					//Turn off yellow light
		do_gettimeofday(&YellowLightEnd);		//Collect time stamp of when yellow light ends
		rtf_put(2, &YellowLightEnd, sizeof(YellowLightEnd));		//Send timeStamp of yellow light end
		*PBDR |= 0x20;							//Turn on red light
		rt_task_wait_period();					//wait for a period
		*PBDR &= 0xFFFFFFDF;					//Turn off red light
	}

}


int init_module(void)
{
		startPtr = (unsigned long *) __ioremap(0x80840000,4096,0);
		//set startPtr2 to VIC2 Base Address: 0x800C0000 (beginning of second mapped area)
		startPtr2 = (unsigned long *) __ioremap(0x800C0000,4096,0);
		//offsets to port B at address location 0x80840004
		PBDR = (unsigned long *) ((char *) startPtr + 0x04);
		//offsets to DDR for port B at address location 0x80840014
		PBDDR = (unsigned long *) ((char *) startPtr + 0x14);
		GPIOBIntEn = (unsigned long *) ((char *) startPtr + 0xB8);		//offset to GPIOBIntEn
		GPIOBIntType1 = (unsigned long *) ((char *) startPtr + 0xAC);	//offset to GPIOBIntType1
		GPIOBIntType2 = (unsigned long *) ((char *) startPtr + 0xB0);	//offset to GPIOBIntType2
		GPIOBEOI = (unsigned long *) ((char *) startPtr + 0xB4);		//offset to GPIOBEOI
		GPIOBDB = (unsigned long *) ((char *) startPtr + 0xC4);			//offset to GPIOBDB
		RawIntStsB = (unsigned long *) ((char *) startPtr + 0xC0);		//offset to RawIntStsB

		//Offset from startPtr2
		VIC2SoftIntClear = (unsigned long *) ((char *) startPtr2 + 0x1C);
		VIC2IntEnable = (unsigned long *) ((char *) startPtr2 + 0010);

		*PBDDR &= 0xFFFFFFE0;			//Set data driection bits to low for bits 0 through 4 of port B
		*GPIOBIntType1 |= 0x1F;			//Set bits 0 through 4 of Port B to EDGE sensitive
		*GPIOBIntType2 &= 0xFFFFFFE0; 	//Set bits 0 through 4 of Port B to FALLING edge sensitive
		*GPIOBDB |= 0x1F; 				//Set bits 0 through 4 of Port B to debounce

		//Set data direction bits 5, 6 and 7 to high for port B to output
		*PBDDR |= 0xE0;
		//Turns all lights off
		*PBDR &= 0xFFFFFF1F;

		//set to periodic mode
		rt_set_periodic_mode();
		period = start_rt_timer(nano2count(100000));

		//initialize real time task, and make it periodic
		rt_task_init(&mytask, rt_process, 0, 256, 0, 0, 0);
		rt_task_make_periodic(&mytask, rt_get_time()+10*period, 4000*period);

		rtf_create(0,1*sizeof(Time));				//create fifo 0
		rtf_create(1,1*sizeof(Time));				//create fifo 1
		rtf_create(2,1*sizeof(Time));				//create fifo 2
		rtf_create(3,1*sizeof(int));				//create fifo 3


		rt_request_irq(59, my_handler, 0, 1);		//Attach my_handler to request line 59
		*GPIOBEOI |= 0x0000001F;					//Clear interrupt before enabling interrupt handling
		*GPIOBIntEn |= 0x0000001F;					//Configure bits 0 through 4 of Port B as interrupts
		rt_enable_irq(59);							//Enable interrupt handling on interrupt line 59

		rt_request_irq(63, my_software_handler, 0, 1);		//Attach my_software_handler to request line 63
		*VIC2SoftIntClear |= 0x80000000;					//Clear software interrupt 63
		*VIC2IntEnable |= 0x80000000;						//Enable line 63 as interrupt
		rt_enable_irq(63);									//Enable interrupt handling on interrupt line 63

	return 0;
}

void cleanup_module(void)
{
	unsigned long *startPtr, *PBDR;

		startPtr = (unsigned long *) __ioremap(0x80840000,4096,0);
		//offsets to port B at address location 0x80840004
		PBDR = (unsigned long *) ((char *) startPtr + 0x04);
		rtf_destroy(0);					//destroy fifo
		rtf_destroy(1);					//destroy fifo
		rtf_destroy(2);					//destroy fifo
		rtf_destroy(3);					//destroy fifo
		*PBDR &= 0xFFFFFF1F;			//Turn off all lights
		rt_disable_irq(59);				//disable interrupt request line 59
		rt_release_irq(59);				//release interrupt request line 59
		rt_disable_irq(63);				//disable interrupt request line 63
		rt_release_irq(63);				//release interrupt request line 63
		rt_task_delete(&mytask);		//delete real time task
		stop_rt_timer();				//stop timer
}


